#    powernapd plugin - Monitors system load
#
#    Copyright (C) 2011 Canonical Ltd.
#
#    Authors: Dustin Kirkland <kirkland@ubuntu.com>
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, version 3 of the License.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os, multiprocessing
from logging import error, debug, info, warn

class LoadMonitor():

    # Initialise
    def __init__(self, threshold):
        self._type = "load"
        self._threshold = threshold
        self._absent_seconds = 0

    # Check system load
    def active(self):
        t = self._threshold
        if t == "n":
            t = multiprocessing.cpu_count()
        if os.getloadavg()[0] > float(t):
            return True
        return False

    def start(self):
        pass

# ###########################################################################
# Editor directives
# ###########################################################################

# vim:sts=4:ts=4:sw=4:et
